
markup.push({

// -------------------------------------------------
// MARK: volume

	GainEffectsBlock:
	{
		"+": "BlockTemplate",
		gxTitle: "Volume",
		geNodeClass: "AHGainEffectsNode",
		h4PresetsId: "GainEffectsPresets",
		blockNeedsLevelMeter: true,
		gxPopoverInfo: "GainEffectsPopover",
		gxLibraryDescription: "Increase or lower audio's volume",
		gxDescriptionKeyPath: "node.volumeDescription",
		gxLibraryIcon: "library.overdrive",
		geImporterParams: ["node.gain"],
		gxChildViews:
		{
			gain: {
				"+": "SliderView.blockFace",
				gxValueKey: "node.gain",
				gxDefaultValue: 1,
				axTitle: "Volume",
				axValueKeyPath: "node.axValue",
				axHelpKeyPath: "node.axHelp",
			},
			readout: {
				"+": "LabelView.blockReadout",
				gxFrameRect: "18,31,83,25",
				gxValueKey: "node.totalGain",
				gxFormatter: "PercentFormatter",
				axFormatter: "PercentFormatter",
				axIsIgnored: false,		//	only visible to prevent VO reading out the single control (the slider) along with block title and doubling up with block description
				axTitle: "Total Gain",
			},
			layerHostView:
			{
				nsClass: "GXLayerHostingView",
				gxLayerZPosition: 2,
				gxLayout: [
					"H:|-12-[self]-12-|",
					"V:|-78-[self(30)]",

					"H:|-4-[leftPeakH]-4-[leftClip(9)]-4-|",
					"H:|-4-[leftRMSH]-4-[leftClip]",
				    "H:|-4-[leftHoldH]-4-[leftClip]",
						   
					"V:|-0-[leftPeakH(9)]",
					"V:|-0-[leftRMSH(9)]",
				    "V:|-0-[leftHoldH(9)]",
				   	"V:|-0-[leftClip(9)]",

					"H:|-4-[rightPeakH]-4-[rightClip(9)]-4-|",
					"H:|-4-[rightRMSH]-4-[rightClip]",
					"H:|-4-[rightHoldH]-4-[rightClip]",
					
					"V:|-16-[rightPeakH(9)]",
					"V:|-16-[rightRMSH(9)]",
					"V:|-16-[rightHoldH(9)]",
					"V:|-16-[rightClip(9)]",
				],
				gxRootLayer:
				{
					nsClass: "GXDrawLayer",
					gxLayerZPosition: 10,
					gxViewModel: { nsClass: "AH4LevelMeterVModel" },
					gxSublayers:
					{
						leftPeakH: { "+": "PeakLayer.blockface" },
						leftRMSH: { "+": "RMSLayer.blockface" },
						leftHoldH: { "+": "HoldLayer.blockface" },
						leftClip: { "+": "ClipLayer.blockface" },
						
						rightPeakH: { "+": "PeakLayer.blockface" },
						rightRMSH: { "+": "RMSLayer.blockface" },
						rightHoldH: { "+": "HoldLayer.blockface" },
						rightClip: { "+": "ClipLayer.blockface" },
					}
				}
			},
//			label: {
//				"+": "LabelView.foreColorTheme1.size11",
//				gxFrameRect: "18,66,83,25",
//				gxDefaultValue: "Overdrive"
//			},
		}
	},

	// MARK: popover

	GainEffectsPopover:
	{
		"+": "PopoverTemplate",
		gxTitle: "Volume",
		gxCanDrawSubviewsIntoLayer: true,
		gxLayout: [ "H:|-12-[self(284)]-12-|",	// sets popover width
					"V:|-12-[self]-12-|",
					"V:|-41-[group]-8-[presetsGroup]"
		],
		gxChildViews:
		{
			title: "PopoverTitle",
			switch: "PopoverOnOffSwitch",
			presetsGroup: presetsGroup(),
			group: {
				"+": "GroupView",
				gxLayout:
				[
					"H:|-0-[self]-0-|",
					"H:|-12-[volumeBtn(20)]-5-[gain]-12-|&alignCenterY",
					"V:|-31-[volumeBtn]-17-[overdriveLabel]-16-|",

					"V:[gainLabel]-(1)-[volumeBtn(20)]&alignLeft",
					"V:[gainReadout]-(-1)-[gain]&alignRight",
					
				 	"H:|-12-[overdriveLabel]-8-[off(51)]-1-[x2(43)]-1-[x3(43)]-1-[x4(47)]-12-|&alignBaseline",
				],
				gxChildViews:
				{
					gain: {
						"+": "SliderView",
						gxValueKey: "node.gain",
                        gxDisableOnKey: "node.muted",
						gxDefaultValue: 1,
						axTitle: "Volume",
						axValueKeyPath: "node.axValue",
						axHelpKeyPath: "node.axHelp",
					},
					gainLabel: labelView("Volume"),
					gainReadout: {
						"+": "ReadoutView",
						gxValueKey: "node.totalGain",
                        gxFormatter: "PercentFormatter",
						gxIntrinsicHeight:20,
						axIsIgnored: true,
						axTitle: "Total Gain",
					},
                    volumeBtn:
                    {
                        "+": "ImageButtonView",
                        gxValueKey: "node.volumeBtnValue",
                        gxDisplayValueKey: "node.volumeBtnDisplayValue",
						gxButtonType: "toggle",
                        gxToolTip: "Mute Audio",
						gxOnToolTip: "Unmute Audio",
						axTitle: "Mute",
                    },
					overdriveLabel: labelView("Overdrive:"),
					off: {
						"+": "ButtonView.leftSegment",
						gxTitle: "Off",
                        axTitle: "overdrive Off",
						gxValueKey: "node.overdrive_x_1",
						gxButtonType: "toggle",
						gxIntrinsicHeight: 22,
						gxBaselineOffset: 5,
					},
					x2: {
						"+": "ButtonView.middleSegment",
						gxTitle: "2×",
                        axTitle: "overdrive 2×",
						gxValueKey: "node.overdrive_x_2",
						gxButtonType: "toggle",
						gxIntrinsicHeight: 22,
						gxBaselineOffset: 5,
					},
					x3: {
						"+": "ButtonView.middleSegment",
						gxTitle: "3×",
                        axTitle: "overdrive 3×",
						gxValueKey: "node.overdrive_x_3",
						gxButtonType: "toggle",
						gxIntrinsicHeight: 22,
						gxBaselineOffset: 5,
					},
					x4: {
						"+": "ButtonView.rightSegment",
						gxTitle: "4×",
                        axTitle: "overdrive 4×",
						gxValueKey: "node.overdrive_x_4",
						gxButtonType: "toggle",
						gxIntrinsicHeight: 22,
						gxBaselineOffset: 5,
					},
				}
			}
		}
	},
		

})
